/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.engine.HostPort;
import org.jenkinsci.remoting.engine.JnlpAgentEndpoint;
import org.jenkinsci.remoting.engine.JnlpEndpointResolver;

public class JnlpAgentEndpointConfigurator
extends JnlpEndpointResolver {
    private static final Logger LOGGER = Logger.getLogger(JnlpAgentEndpointConfigurator.class.getName());
    private final String instanceIdentity;
    private final Set<String> protocols;
    private final String directionConnection;

    public JnlpAgentEndpointConfigurator(String directConnection, String instanceIdentity, Set<String> protocols) {
        this.directionConnection = directConnection;
        this.instanceIdentity = instanceIdentity;
        this.protocols = protocols;
    }

    @Override
    public JnlpAgentEndpoint resolve() throws IOException {
        RSAPublicKey identity;
        try {
            identity = this.getIdentity(this.instanceIdentity);
            if (identity == null) {
                throw new IOException("Invalid instanceIdentity.");
            }
        }
        catch (InvalidKeySpecException e) {
            throw new IOException("Invalid instanceIdentity.");
        }
        HostPort hostPort = new HostPort(this.directionConnection);
        return new JnlpAgentEndpoint(hostPort.getHost(), hostPort.getPort(), identity, this.protocols, null);
    }

    @Override
    public void waitForReady() {
        LOGGER.log(Level.INFO, "Sleeping 10s before reconnect.");
    }
}

