﻿function exportPdfIntegracao(element, orderBy, orderType, pontos, agrupado, requisicao, postgres) {
    element.hide();
    var aguarde = element.parent().find('div.personalizado_aguarde').eq(0);
    aguarde.show();
    var data = {
        firebird: firebird,
        mysql: mysql,
        postgres: postgres,
        filtros: encodeURI(filtros),
        pontos: pontos,
        agrupado: agrupado,
        requisicao: requisicao,
        orderBy: orderBy,
        orderType: orderType
    };

    if (Empresas != undefined) {
        data.Empresas = Empresas;
    }

    $.ajax({
        type: "POST",
        url: address,
        data: data,
        success: function (data) {
            window.open(data, '_blank');
            aguarde.hide();
            element.show();
        },
        crossDomain: true
    });
}

function getCookieParam(name) {
    var params = document.cookie.split(";");
    params = params.map(param => param.split("=")).find(param => param[0] === ` ${name}`);
    return params ? params[1] : "";
}

function exportExcelIntegracao(element, requisicao, postgres) {
    element.hide();
    var aguarde = element.parent().find('div.personalizado_aguarde_excel').eq(0);
    aguarde.show();

    var data = {
        firebird: firebird,
        mysql: mysql,
        postgres: postgres,
        requisicao: requisicao,
        pontos: $("#tipo_relatorio_pontos").is(':checked'),
        filtros: encodeURI(filtros)
    };

    if (Empresas != undefined) {
        data.Empresas = Empresas;
    }

    $.ajax({
        type: "POST",
        url: addressExcel,
        data: data,
        success: function (data) {
            window.open(data, '_blank');
            aguarde.hide();
            element.show();
        },
        crossDomain: true
    });
}

// ----------------------------------
// Funções criada com método interno para decodificação de caracteres
function exportPdfRelatorioIntegracao(element, orderBy, orderType, pontos, agrupado, requisicao, postgres) {
    element.hide();
    var aguarde = element.parent().find('div.personalizado_aguarde').eq(0);
    aguarde.show();
    var data = {
        firebird: firebird,
        mysql: mysql,
        postgres: postgres,
        filtros: uncodeString(filtros),
        pontos: pontos,
        agrupado: agrupado,
        requisicao: requisicao,
        orderBy: orderBy,
        orderType: orderType
    };

    if (Empresas != undefined) {
        data.Empresas = Empresas;
    }

    $.ajax({
        type: "POST",
        url: address,
        data: data,
        success: function (data) {
            window.open(data, '_blank');
            aguarde.hide();
            element.show();
        },
        crossDomain: true
    });
}

function exportExcelRelatorioIntegracao(element, requisicao, postgres) {
    element.hide();
    let aguarde = element.parent().find('div.personalizado_aguarde_excel').eq(0);
    aguarde.show();

    let data = {
        firebird: firebird,
        mysql: mysql,
        postgres: postgres,
        requisicao: requisicao,
        pontos: $("#tipo_relatorio_pontos").is(':checked'),
        filtros: uncodeString(filtros)
    };

    if (Empresas != undefined) {
        data.Empresas = Empresas;
    }

    $.ajax({
        type: "POST",
        url: addressExcel,
        data: data,
        success: (data) => {
            window.open(data, '_blank');
            aguarde.hide();
            element.show();
        },
        crossDomain: true
    });
}
// ----------------------------------

function personalizado_abre() {
    if ($('#personalizado_contentFiltros').is(':visible')) {
        personalizado_fecha();
    } else {
        $('#personalizado_contentFiltros').slideDown('fast', function () { $('#personalizado_sinal_filtros').html('-'); });
    }
}

function personalizado_fecha() {
    $('#personalizado_contentFiltros').slideUp('fast', function () { $('#personalizado_sinal_filtros').html('+'); });
}

function openNewReportFromGraph(event, url) {
    var filtros = [];

    var filtroCampo = new Array();
    $("select[name='filtroCampos']").each(function () { if ($(this).val() != '') filtroCampo.push($(this).val()); });
    var filtroCampoID = new Array();
    var filtroOpcao = new Array();
    $("select[name='opcao']").each(function () { filtroOpcao.push($(this).val()); filtroCampoID.push(this.id); });
    var filtroValor1 = new Array();
    $("input[name='valorFiltro1']").each(function () { filtroValor1.push($(this).val()); });
    var filtroValor2 = new Array();
    $("input[name='valorFiltro2']").each(function () { filtroValor2.push($(this).val()); });

    var kkCont, aid;
    for (kkCont = 0; kkCont < filtroOpcao.length; kkCont++) {
        if (filtroOpcao[kkCont] == 'selecionar' || filtroOpcao[kkCont] == 'filtrar') {
            aid = filtroCampoID[kkCont].split("_");
            filtroValor1[kkCont] = $("#inputSelect_" + aid[1]).val().join();
            filtroValor2[kkCont] = '';
        }
    }

    for (counter = 0; counter < filtroCampo.length; counter++) {
        var campo = filtroCampo[counter];

        if (campo == "")
            continue;

        campo = campo.split(",")[1];

        filtros.push({
            CAMPO: campo,
            OPERADOR: filtroOpcao[counter],
            VALOR1: filtroValor1[counter],
            VALOR2: filtroValor2[counter]
        });
    }

    loadReport(url, "", JSON.stringify(filtros), event.point.category, event.point.y, event.point.series.name);
}

var emCarregamentoDetalhes = false;

function loadReport(url, id, filtros, x, y, legenda) {
    if (emCarregamentoDetalhes)
        return;

    emCarregamentoDetalhes = true;
    $.ajax({
        type: "POST",
        url: url,
        data: {
            id: id,
            filtros: filtros,
            eixoX: x,
            eixoY: y,
            legenda: legenda
        },
        success: function (data) {
            $("#janela_modalGrafico").html('');
            $("#overlay").html('');

            var overlay = '<div id="overlay"></div>';
            var overlayCSS = { 'position': 'absolute', 'width': pageWidth + 'px', 'height': pageHeight + 'px', 'left': '0', 'top': '0', 'display': 'none', 'z-index': '9999998' };

            var janela = '<div id="janela_modalGrafico"></div>';
            var janelaCSS = { 'position': 'absolute', 'top': '50%', 'left': '50%', 'width': '790px', 'height': '450px', 'margin-left': '-395px', 'margin-top': '-225px', 'border': '4px solid #63A0CE', 'border-radius': '10px 0px 10px 10px', 'z-index': '9999999', 'overflow-y': 'auto' };

            var btnFechar = '<div class="fecharModal"><img id="btnFecharGrafico" src="' + basepath + 'www/imagem/close.png" alt="Fechar" title="Fechar" onClick="fecharModalGrafico()" /></div>';

            $("body").append(overlay);
            $("body").append(janela);
            $("#overlay").css(overlayCSS).fadeIn('fast', function () {

                $("#janela_modalGrafico").append(data);

                $("#janela_modalGrafico").append(btnFechar);
                $("#btnFecharGrafico").fadeIn("slow");

                $("#janela_modalGrafico").css(janelaCSS).fadeIn("slow");
            });

            emCarregamentoDetalhes = false;
        },
        crossDomain: true
    });
}

function verifyPages() {
    var pages = $("div.page").length;

    if (pages <= 1) {
        $("a.linkProximo").addClass("linkDisabled");
    }
}

function uncodeString(value) {
    return $('<div>').html(value)[0].textContent;
}

(function ($, d) {
    $(d).ready(function () {
        mascarasFiltro();

        verifyPages();
    });

    $(d).on("click", "a.linkProximo", function (evt) {
        evt.stopImmediatePropagation();
        var activePage = $("div.pageActive");

        if (activePage.hasClass("lastPage")) {
            return;
        }

        activePage.removeClass("pageActive").addClass("pageInactive");
        var counter = parseInt(activePage.data("counter")) + 1;
        $("div[data-counter=" + counter + "]").removeClass("pageInactive").addClass("pageActive");

        $("a.linkAnterior").removeClass("linkDisabled");

        if ($("div[data-counter=" + counter + "]").hasClass("lastPage")) {
            $("a.linkProximo").addClass("linkDisabled");
        }
    });

    $(d).on("click", "a.linkAnterior", function (evt) {
        evt.stopImmediatePropagation();
        var activePage = $("div.pageActive");

        if (activePage.hasClass("firstPage")) {
            return;
        }

        activePage.removeClass("pageActive").addClass("pageInactive");
        var counter = parseInt(activePage.data("counter")) - 1;
        $("div[data-counter=" + counter + "]").removeClass("pageInactive").addClass("pageActive");

        $("a.linkProximo").removeClass("linkDisabled");

        if ($("div[data-counter=" + counter + "]").hasClass("firstPage")) {
            $("a.linkAnterior").addClass("linkDisabled");
        }
    });

    var elementEvent;

    $(d).on("click", "[data-hasclickevent=true]", function (evt) {
        evt.stopImmediatePropagation();

        elementEvent = $(this);

        eval(elementEvent.data("clickevent"));
    });

    $(d).on("click", "[data-hasmouseoverevent=true]", function (evt) {
        evt.stopImmediatePropagation();

        elementEvent = $(this);

        eval(elementEvent.data("mouseoverevent"));
    });

    $(d).on("click", "[data-hasmousedownevent=true]", function (evt) {
        evt.stopImmediatePropagation();

        elementEvent = $(this);

        eval(elementEvent.data("mousedownevent"));
    });

    $(d).on("click", "[data-hasmousemoveevent=true]", function (evt) {
        evt.stopImmediatePropagation();

        elementEvent = $(this);

        eval(elementEvent.data("mousemoveevent"));
    });

    $(d).on("click", "[data-hasmouseupevent=true]", function (evt) {
        evt.stopImmediatePropagation();

        elementEvent = $(this);

        eval(elementEvent.data("mouseupevent"));
    });

    $(d).on("keydown", ".onlyNumbers", function (e) {
        // Allow: backspace, delete, tab, escape, enter and .
        if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
            // Allow: Ctrl+A
            (e.keyCode == 65 && e.ctrlKey === true) ||
            // Allow: Ctrl+C
            (e.keyCode == 67 && e.ctrlKey === true) ||
            // Allow: Ctrl+X
            (e.keyCode == 88 && e.ctrlKey === true) ||
            // Allow: home, end, left, right
            (e.keyCode >= 35 && e.keyCode <= 39)) {
            // let it happen, don't do anything
            return;
        }
        // Ensure that it is a number and stop the keypress
        if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
            e.preventDefault();
        }
    });

    function openNewReport() {
        loadReport(elementEvent.data("urlrelatorio"), elementEvent.data("id"), JSON.stringify(elementEvent.data("filtros")), "", "", "");
    }

    function getLatLong() {
        var latitude = elementEvent.data("latitude");
        var longitude = elementEvent.data("longitude");
        var id = elementEvent.data("id");

        processLatLong(id, latitude, longitude, elementEvent);
    }
}
)(jQuery, document);